<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSubMenuTitlesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('sub_menu_titles', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('sub_menu_id')->unsigned();
            $table->integer('category_id')->unsigned()->nullabel();
            $table->unsignedTinyInteger('type')->default(0);
            $table->string('title',250);
            $table->string('slug',250)->unique()->nullable();
            $table->string('url')->unique()->nullable();
            $table->smallInteger('priority')->nullable();

            $table->foreign('category_id')->references('id')->on('category')->onDelete('cascade');

            $table->foreign('sub_menu_id' )->references('id')->on('dynamic_sub_menus')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('sub_menu_titles');
    }
}
