<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateDynamicMenuSlotsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('dynamic_menu_slots', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->integer('dynamic_menu_id')->unsigned()->nullable();
            $table->string('menu_slot_name',200)->unique();
            $table->string('slug',250)->unique();
            $table->smallInteger('status',0);
            $table->foreign( 'dynamic_menu_id' )->references('id')->on('dynamic_menus')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('dynamic_menu_slots');
    }
}
