<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateDynamicSubMenusTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('dynamic_sub_menus', function (Blueprint $table) {
            $table->increments('id');
            $table->unsignedTinyInteger('type')->default(1);
            $table->integer('dynamic_menu_id')->unsigned();
            $table->string('name',200)->unique();
            $table->string('cat_name',200)->nullable();
            $table->string('slug',255)->unique()->nullable();
            $table->integer('category_id')->unsigned()->nullable();
            $table->integer('priority')->nullable();
            $table->boolean('status')->default(0);
            $table->string('url',255)->nullable();
            $table->foreign( 'dynamic_menu_id' )->references('id')->on('dynamic_menus')->onDelete('cascade');
            $table->foreign( 'category_id' )->references('id')->on('category')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('dynamic_sub_menus');
    }
}
