<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateDynamicMenusTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('dynamic_menus', function (Blueprint $table) {

            $table->increments('id');
            $table->unsignedTinyInteger('type')->default(1);
            $table->integer('stuffType_id')->unsigned()->nullable();
            $table->string('name',200)->unique();
            $table->string('stuffType_name',200)->nullable();
            $table->string('slug',255)->unique()->nullable();
            $table->string('url',255)->nullable();
            $table->boolean('status')->default(0);
            $table->foreign( 'stuffType_id' )->references('id')->on('stufftype')->onDelete('cascade');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('dynamic_menus');
    }
}
