<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateProductsTecInfoTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('products_tecInfo', function (Blueprint $table) {
            $table->increments('id');
            $table->string('code',50);
            $table->integer('category_id')->unsigned();
            $table->string('tec_info_key',255);
            $table->string('slug',255)->unique();
            $table->integer('parent_id')->default(0)->index();
            $table->integer('hierarchy')->default(1);
            $table->smallInteger('status')->default(0);
            $table->foreign('category_id')->references('id')->on('category')->onDelete('cascade');
            $table->timestamps();

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('products_tecInfo');
    }
}
