<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateProductsColorTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('products_color', function (Blueprint $table) {
            $table->increments('id');
            $table->string('code',25);
            $table->unsignedTinyInteger('type')->default(0);
            $table->integer('product_id')->unsigned();
            $table->integer('color_id')->unsigned()->nullable();
            $table->integer('size_id')->unsigned()->nullable();
            $table->integer('qty')->default(0);
            $table->unsignedInteger('base_sell_price');
            $table->unsignedInteger('discount_sell_price')->nullable();
            $table->integer('discount')->nullable();
            $table->unsignedSmallInteger('priority');
            $table->unsignedTinyInteger('status')->default(0);
            $table->boolean('available')->default(0);
            $table->foreign('product_id' )->references('id')->on('products')->onDelete('cascade');
            $table->foreign('color_id' )->references('id')->on('color_store')->onDelete('cascade');
            $table->foreign('size_id' )->references('id')->on('sizes')->onDelete('cascade');
            $table->softDeletes();
            $table->timestamps();

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('products_color');

    }
}
