<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateProductsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('products', function (Blueprint $table) {
            $table->increments('id');
            $table->string('code',25)->nullable();
            $table->string('name',255);
            $table->string('eng_name',255);
            $table->string('slug',255)->unique();
            $table->unsignedTinyInteger('type')->default(0);
            $table->string('stuffType',250);
            $table->string('brand',250);
            $table->string('category',250);
            $table->string('sub_category',250)->nullable();
            $table->integer('stuffType_id')->unsigned();
            $table->integer('brand_id')->unsigned();
            $table->integer('category_id')->unsigned();
            $table->integer('qty')->default(0);
            $table->text('short_description')->nullable();
            $table->string('base_img_url',150)->nullable();
            $table->string('base_medium_url',150)->nullable();
            $table->string('base_thumbnail_url',150)->nullable();
            $table->unsignedInteger('buy');
            $table->unsignedInteger('base_sell_price');
            $table->unsignedInteger('discount_sell_price')->nullable();
            $table->unsignedMediumInteger('alarm_level')->nullable();
            $table->text('review')->nullable();
            $table->unsignedSmallInteger('weight')->nullable();
            $table->unsignedInteger('view_count')->default(0);
            $table->unsignedInteger('sold_count')->default(0);
            $table->tinyInteger('status')->default(0);
            $table->boolean('available')->default(0);
            $table->foreign('stuffType_id' )->references('id')->on('stuffType')->onDelete('cascade');
            $table->foreign('brand_id' )->references('id')->on('brands')->onDelete('cascade');
            $table->foreign('category_id' )->references('id')->on('category')->onDelete('cascade');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('products');

    }
}
