<?php

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('users', function (Blueprint $table) {
            $table->increments('id');
            $table->string('fname',250)->nullable();
            $table->string('lname',250)->nullable();
            $table->string('email',250)->unique()->nullable();
            $table->string('mobile',20)->unique()->nullable();
            $table->string('password', 100);
            $table->string('melli_code',20)->nullable();
            $table->string('tell',20)->nullable();
            $table->string('urgent_phone_no',20)->nullable();
            $table->string('birth',12)->nullable();
            $table->boolean('gender')->nullable();
            $table->string('state',200)->nullable();
            $table->string('city',200)->nullable();
            $table->string('postal_code',15)->nullable();
            $table->text('address')->nullable();
            $table->string('role',10)->default('costumer');
            $table->smallInteger('owner')->default(0);
            $table->boolean('confirmed')->default(0);
            $table->boolean('completed')->default(0);
            $table->string('token',40)->unique()->nullable();
            $table->tinyInteger('vip')->nullable()->default(0);
            $table->rememberToken();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('users');
    }
}
