<?php


/*
 * @param string
 * Converting english numbers to persian numbers
 */

use App\Models\Products;
use Morilog\Jalali\jDate;

function convert($string,$to_lang = 'fa')
{
    $western = ['0','1','2','3','4','5','6','7','8','9'];
    $eastern = ['۰','۱','۲','۳','۴','۵','۶','۷','۸','۹'];

    if($to_lang == 'fa'){
        return str_replace($western, $eastern, $string);
    }elseif($to_lang == 'en'){
        return str_replace( $eastern,$western, $string);
    }

    return $string;
}

/**
 * Set a flash message in the session.
 *
 * @param  string $message
 * @return void
 */
function flash($message) {
    session()->flash('message', $message);
}

function discount($base_price,$discount_price,Products $product = null)
{
    if(is_null($product)){
        if (!is_null($discount_price)){
            if ($base_price > $discount_price) {
                $percentage = round(($base_price - $discount_price) / $base_price * 100, 1, PHP_ROUND_HALF_DOWN);

                return $percentage;
            }
        }
    }else{
        if($product->checkAvailable()){
            if (!is_null($discount_price)){
                if ($base_price > $discount_price) {
                    $percentage = round(($base_price - $discount_price) / $base_price * 100, 1, PHP_ROUND_HALF_DOWN);

                    return $percentage;
                }
            }
        }
    }

    return false;
}

function priceFormat($number)
{
    if(strpos($number,".") !== false){
        $number = number_format($number , 2, ".", ",");
    }else{
        $number = number_format($number , 0, ".", ",");
    }

    return $number;
}

function roundDiscount($number){

    $number = round($number/100, 0, PHP_ROUND_HALF_DOWN)* 100;

    return $number;
}

function persianDiffForHumans($timeStamp){
    $humanTime = $timeStamp->diffForHumans();

    $western = [
        '0','1','2','3','4','5','6','7','8','9',
        'years','year','months','month','weeks','week',
        'days','day','hours','hour','minutes','minute',
        'seconds','second','ago','from now'
    ];
    $eastern = [
        '۰','۱','۲','۳','۴','۵','۶','۷','۸','۹',
        'سال','سال','ماه','ماه','هفته','هفته',
        'روز','روز','ساعت','ساعت','دقیقه','دقیقه',
        'ثانیه','ثانیه','قبل','باقی مانده'
    ];

    return str_replace($western, $eastern, $humanTime);

}

function encrypt_decrypt($action,$cartId){
    $output = false;
    $encrypt_method = 'AES-256-CBC';
    $secret_key = env('ENC_KEY');
    $secret_iv  = env('ENC_KEY');
    // hash
    $key = hash('sha256', $secret_key);

    // iv - encrypt method AES-256-CBC expects 16 bytes - else you will get a warning
    $iv = substr(hash('sha256', $secret_iv), 0, 16);
    if ( $action == 'encrypt' ) {
        $output = openssl_encrypt($cartId, $encrypt_method, $key, 0, $iv);
        $output = base64_encode($output);
    } else if( $action == 'decrypt' ) {
        $output = openssl_decrypt(base64_decode($cartId), $encrypt_method, $key, 0, $iv);
    }
    return $output;
}

//function toNum($data) {
//    $alphabet = [
//        'ا','آ','ب','پ','ت','ث',
//        'ج','چ','ح','خ','د','ذ',
//        'ر','ز','ژ','س','ش','ص',
//        'ض','ط','ظ','ع','غ','ف',
//        'ق','ک','گ','ل','م','ن',
//        '۱','۲','۳','۴','۵','۶','۷','۸','۹','۰',
//        '1','2','3','4','5','6','7','8','9','0',
//        'b', 'c', 'd', 'e', 'f',
//        'g', 'h', 'i', 'j', 'k',
//        'l', 'm', 'n', 'o', 'p',
//        'q', 'r', 's', 't', 'u',
//        'v', 'w', 'x', 'y', 'z',
//        'A','B','C','D','E','F',
//        'G','H','I','J','K','L',
//        'M','N','O','P','Q','R',
//        'S','T','U','V','W','X',
//        'Y','Z','و','ه','ی','ئ','ي','ة','ة','ؤ','ك',
//        ')','(','-','_','+','=','*','&','%',
//        '$','#','@','!','?',',','.','>','<',':',';','}','{','[',']','|','`','~','"','\''
//    ];
//    $alpha_flip = array_flip($alphabet);
//
//    $return_value = '';
//
//
//    $data2 = array_filter(preg_split('/(?<!^)(?!$)/u',$data));
//
//
//    foreach ($data2 as $value){
//        if($value != " "){
//            if(array_search($value,$alpha_flip)){
//                $return_value .= $alpha_flip[$value];
//            }else{
//                $return_value .= 'te';
//            }
//        }
//    }
//
//
//    $legnth = strlen($return_value);
//    if( $legnth >= 10){
//        if($legnth <= 20){
//            $return_value = preg_replace('/(.).{3,3}/', '$1', $return_value);
//        }elseif($legnth > 20 && $legnth <= 30){
//
//            $return_value = preg_replace('/(.).{5,5}/', '$1', $return_value);
//        }elseif($legnth > 30){
//
//            $return_value = preg_replace('/(.).{8,8}/', '$1', $return_value);
//        }
//    }
//    return $return_value;
//}

function saveLog($response)
{
    if(is_null($response)){
        $response = 'empty';
    }

    file_put_contents('log.txt',"\n-------". $date = jDate::forge('now')->format('datetime')."-----------\n". print_r($response,true) ." \n\n-----------------\n\n", FILE_APPEND);

}

function searchArray($array, $key, $value)
{

    if (is_array($array)) {
        if (isset($array[$key]) && $array[$key] == $value) {
            return true;
        }
    }

    return false;

}

function shortenNumber($n, $precision = 2){
    if($n > 10000){
        if ($n < 1000000) {
            // Anything less than a million
            $n_format =  number_format($n / 1000,$precision)+0;
        } else if ($n < 1000000000) {
            // Anything less than a billion
            $n_format = number_format($n / 1000000,$precision) +0;
        } else {
            // At least a billion
            $n_format = number_format($n / 1000000000,$precision)+0;
        }
    }else{
        $n_format = $n;
    }


    return $n_format;
}

function showDecimal($n){
    if($n > 10000){
        if ($n < 1000000) {
            $n_format = 'هزار ';
        } else if ($n < 1000000000) {
            // Anything less than a billion
            $n_format = 'میلیون ';
        } else {
            // At least a billion
            $n_format = 'میلیارد ';
        }
    }else{
        $n_format = '';
    }


    return $n_format;
}

function make_url($type,$category_id = Null,$brand_id = Null,$tec_id = Null,$tec_code = Null,$url = Null){
    if($type == 1){
        return 'category[0]='.$category_id.'&brand['.$brand_id.']='.$brand_id;
    }elseif($type == 2){
        return  'category[0]='.$category_id;
    }elseif($type == 3){
        return 'category[0]='.$category_id.'&tecInfo['. $tec_code.']['.$tec_id .']='. $tec_id;
    }elseif($type == 4){
        return $url;
    }
}

function checkTecSelect($tecInfo,$option){

    if(array_key_exists($option->tec_code,$tecInfo)){
        foreach ($tecInfo[$option->tec_code] as $tec){
            if($option->tec_id == $tec){
                return true;
            }
        }
    }
    return false;
}

function path_to_images($url =''){
    return url("/app/".$url);
}

function deleteRecord($record, $message = 'پرونده با موفقیت حذف شد'){
    try{
        $record->delete();

        alert()->flash('حذف شد', 'success', [
            'text' => $message,
            'type' => 'success',
            'timer' => 1200
        ]);
    }
    catch (\Illuminate\Database\QueryException $e) {
        $message =  'این پرونده در دیگر ماژول ها استفاده شده است، لطفا ابتدا از آن قسمت اقدام به حذف پرونده کرده و سپس بازگردید';
        alert()->flash('خطا', 'error', [
            'text' => $message,
            'type' => 'error',
        ]);
    }

}

function deleteSimple($record){
    try{
        $record->delete();
    }
    catch (\Illuminate\Database\QueryException $e) {

    }
}

function getMonthName($monthNumber){
    $dateObj   = DateTime::createFromFormat('!m', $monthNumber);
    return $monthName = $dateObj->format('F');
}

function getNumType($number){

    if($number % 2 == 0){
        return 'even';
    }else{
        return 'odd';
    }
}

