<?php

namespace App\Providers;

use Illuminate\Support\Facades\Event;
use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;

class EventServiceProvider extends ServiceProvider
{
    /**
     * The event listener mappings for the application.
     *
     * @var array
     */
    protected $listen = [
        'App\Events\SearchIndex' => [
            'App\Listeners\SearchIndexListener',
        ],
        'App\Events\SearchUpdateIndex' => [
            'App\Listeners\SearchUpdateIndexListener',
        ],
        'App\Events\ShipmentEvent' => [
            'App\Listeners\ShipmentListener',
        ],
        'App\Events\inventoryCheckoutEvent' => [
            'App\Listeners\inventoryCheckoutListener',
        ],
        'App\Events\ProfitEvent' => [
            'App\Listeners\ProfitListener',
        ],
        'App\Events\RegisterEvent' => [
            'App\Listeners\RegisterSmsListener',
        ],
        'App\Events\ResetPassEvent' => [
            'App\Listeners\ResetPassSmsListener',
        ],
        'App\Events\PurchaseSuccessfulEvent' => [
            'App\Listeners\PurchaseOwnerSms',
            'App\Listeners\PurchaseCostumerSms',
        ],
        'App\Events\PurchaseSendByPostEvent' => [
            'App\Listeners\PurchasePostSms',
        ],
        'App\Events\PurchaseSendByPeykEvent' => [
            'App\Listeners\PurchasePeykSms',
        ],
        'App\Events\CartSmsEvent' => [
            'App\Listeners\CartSmsListener',
        ],
        'App\Events\ProductColorUpdateEvent' => [
            'App\Listeners\ProductColorUpdateListener',
        ],
    ];


    /**
     * Register any events for your application.
     *
     * @return void
     */
    public function boot()
    {
        parent::boot();

        //
    }
}
