<?php

namespace App\Providers;

use App\Models\Cart;
use App\Models\Link;
use App\Models\MsParticipant;
use App\Models\Payment;
use App\Models\Products;
use App\Models\ProductsColor;
use App\Models\Review;
use App\Models\Service;
use App\Models\Setting;
use App\Models\SocialMedia;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Cookie;
use Illuminate\Contracts\Cookie\Factory;
use Morilog\Jalali\jDate;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot(Factory $cookie)
    {
        $products = Products::orderBy('updated_at', 'desc')->get();

        $alarms = [];
        foreach ($products as $product) {
            if (isset($product)) {
                if ($product->alarm_level > $product->qty) {
                    $alarms[] = array(
                        'name' => $product->name,
                        'number' => $product->qty,
                        'level' => $product->alarm_level,
                    );
                }
            }
        }

        $alarm_comments = Review::where('confirmed', 0)->get();

        $newOrders = Payment::where('status', 1)->get();

        $unConfirmedCarts = Cart::getUnConfirmedCarts();

        $setteng = Setting::first();

        $socials    =   SocialMedia::all();

        $links  =   Link::all();

        $services   =   Service::orderBy('order','ASC')->limit(6)->get();

        $this->checkCookie($cookie);
        $jdate = new jDate();

//-------------- public front----------------- \\



        view()->share(compact('newOrders','unConfirmedCarts','jdate','alarms', 'alarm_comments','setteng','socials','links','services'));

    }

    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
            $this->app->bind('path.public', function() {
        return base_path('public_html');
    });
    }
    
    public function checkCookie($cookie){
        $cartItems = Cart::cartItems();
        if(is_null($cartItems) && Auth::check() == false) {
            $cookieItems = Cookie::get('cart');
            $cookieItems = json_decode($cookieItems);

            if (isset($cookieItems)) {
                foreach ($cookieItems as $id) {

                    $item = ProductsColor::whereId($id)->first();
                    if (!isset($item)) {
                        Cart::removeFromCartCookie($id, $cookie);
                    }
                }
            }
        }
    }
}
