<?php

namespace App\Models;

use Illuminate\Notifications\Notifiable;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Zizaco\Entrust\Traits\EntrustUserTrait;
class User extends Authenticatable
{
    use Notifiable,EntrustUserTrait;

    public $timestamps = true;
    public $fillable=[
        'fname', 'lname', 'email', 'mobile', 'password', 'fname', 'lname', 'melli_code', 'tell',
        'urgent_phone_no', 'email', 'birth', 'gender', 'state', 'city', 'postal_code', 'address',
        'completed', 'confirmed','token','role'
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token'
    ];

    protected $table= 'users';

    public function FavoriteProducts(){
      return  $this->belongsToMany(User::class,'Favorites','user_id','product_id')->withTimestamps();
    }

    public function Cart(){
        return $this->hasMany(Cart::class,'user_id');
    }

    public function Review(){
        return($this->hasMany( Review::class,'user_id' ));
    }

    public function Address(){
        return $this->hasOne(PaymentAddress::class,'user_id');
    }

    public function roles(){
        return $this->belongsToMany(Role::class);
    }

    public function Message(){
        return $this->belongsToMany(MsMessage::class,'ms_participants','user_id','ms_id');
    }

    public function userMessagePivot(){
        return $this->hasMany(MsParticipant::class,'user_id');
    }

    public function getUserMessagePivot(MsMessage $message){
        return $this->userMessagePivot()->where('user_id',$this->id)
            ->where('ms_id',$message->id)->first();

    }

    public function getPaidCart($count = false){
        if($count)
            return count($this->Cart()->where('paid',1)->get());


        return $this->Cart()->where('paid',1)->get();
    }

    public function getActiveCart(){
        return $cart = $this->Cart()->where('paid',0)
            ->where('confirmed',0)
            ->first();
    }

    public function totalBuy(){
        $carts = $this->getPaidCart();

        $totalBuy = 0;

        foreach ($carts as $cart){
            $totalBuy += $cart->CartProduct()->sum('total');
        }

        return $totalBuy;
    }

    public function createCart(){

        $cart = $this->getActiveCart();

        if(!isset($cart)){
            $cart = new Cart();

            $cart->create([
                'user_id' => $this->id,
                'paid' => 0,
            ]);
        }

        return $cart;
    }

    public static function encrypt_decrypt($action,$cartId){
        $output = false;
        $encrypt_method = 'AES-256-CBC';
        $secret_key = '@SalarRockTyphoonGalaxySi9000';
        $secret_iv = '@SalarRockTyphoonGalaxySi9000...';
        // hash
        $key = hash('sha256', $secret_key);

        // iv - encrypt method AES-256-CBC expects 16 bytes - else you will get a warning
        $iv = substr(hash('sha256', $secret_iv), 0, 16);
        if ( $action == 'encrypt' ) {
            $output = openssl_encrypt($cartId, $encrypt_method, $key, 0, $iv);
            $output = base64_encode($output);
        } else if( $action == 'decrypt' ) {
            $output = openssl_decrypt(base64_decode($cartId), $encrypt_method, $key, 0, $iv);
        }
        return $output;
    }

    public  function article(){
        return $this->hasMany(Article::class);
    }


}
