<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class TecInfoProduct extends Model
{
    protected $primaryKey = 'tec_id';

    protected $fillable=['tecInfo_id','product_id','value'];

    protected function Product(){
        return $this->belongsTo(Products::class,'product_id');
    }

    protected function TecInfo(){
        return $this->belongsTo(ProductsTecInfo::class,'tecInfo_id');
    }

    public function getProductTecValue($product){

        if(is_object($product)){
            return $this->where('product_id',$product->id)->first();
        }
        return $this->where('product_id',$product)->first();
    }


    public function SubMenuSetting(){
        return $this->hasMany( DynamicSubMenuSetting::class,'tec_id','tec_id' );
    }

    public function Filter(){
        return $this->hasMany(Filter::class,'tec_id','tec_id' );
    }
}
