<?php

namespace App\Models;


use Illuminate\Database\Eloquent\Model;
use Cviebrock\EloquentSluggable\Sluggable;

class SubMenuTitle extends Model
{
    use Sluggable;


    public function sluggable()
    {
        return [
            'slug' => [
                'source' => 'title'
            ]
        ];
    }
    protected $fillable=['category_id','priority','type','title','sub_menu_id','url'];


    public function SubMenuSetting(){
        return $this->hasMany( DynamicSubMenuSetting::class,'title_id' );
    }

    public function DynamicSubMenu(){
        return $this->belongsTo(DynamicSubMenu::class,'sub_menu_id');
    }

    public function Category(){
        return $this->belongsTo(Category::class,'category_id');
    }

    public function path(){
        $url = '';
        if($this->type == 0){
             $url .= url('/search?category[0]='.$this->category_id);
        }elseif($this->type == 1){
            $category = $this->Category()->first();
             $url .= url('/category/'.$category->slug);
        }elseif($this->type == 2){
            $url .= $this->url;
        }

        return $url;
    }
}
