<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Cviebrock\EloquentSluggable\Sluggable;

class StuffType extends Model
{
    use Sluggable;


    public function sluggable()
    {
        return [
            'slug' => [
                'source' => 'stuffType'
            ]
        ];
    }
    public $timestamps = true;

    protected $table = 'stufftype';
    protected $fillable = ['stuffType'];


    public function path(){
        return "/product_type/$this->slug";
    }
    public function Category(){
        return($this->hasMany( 'App\Models\Category','stuffType_id' ));
    }

    public function Product()
    {
        return $this->hasMany(Products::class, 'stuffType_id');
    }

}
