<?php

namespace App\Models;

use Cviebrock\EloquentSluggable\Sluggable;
use Illuminate\Database\Eloquent\Model;

class Size extends Model
{

    use Sluggable;


    public function sluggable()
    {
        return [
            'slug' => [
                'source' => 'name'
            ]
        ];
    }

    protected $fillable=['category_id','name','default','code','slug'];

    public function Category(){
         return $this->belongsTo(Category::class,'category_id');
    }

    public function ProductColor(){
        $this->hasMany(ProductsColor::class,'size_id');
    }
}
