<?php

namespace App\Models\Search;
use App\Models\ProductsGallery;
use App\Models\Review;
use App\Models\StuffType;
use Illuminate\Database\Eloquent\Model;
use Laravel\Scout\Searchable;
use phpDocumentor\Reflection\Types\Integer;
use TeamTNT\TNTSearch\TNTSearch;
use Illuminate\Database\Eloquent\Collection;

class brand_product extends Model
{

    use Searchable;

    public $timestamps = true;
    protected $table = 'products';

    protected $fillable = [

        'inventory_id',
        'brand_id',
        'category_id',
        'short_description',
        'base_img_url',
        'base_medium_url',
        'base_thumbnail_url',
        'base_sell_price',
        'discount_sell_price',
        'alarm_level',
        'tec_info_keyAndValues',
        'review',
    ];

    protected $casts = [
        'tec_info_keyAndValues'=>'array',
        'size'=>'array',
    ];


    /**
     * Make the given model instance searchable.
     *
     * @return void
     */
    public function searchable()
    {
        Collection::make(['brand_id'])->searchable();
    }


    /**
     * Get the index name for the model.
     *
     * @return string
     */
    public function searchableAs()
    {
        return 'brand';
    }

    /**
     * Get the indexable data array for the model.
     *
     * @return array
     */
    public function toSearchableArray()
    {
        return [
            'id' => $this->id,
            'brand_id' => $this->brand_id,
        ];
    }

    public function productCode(){
        $productCode = "TDX-".sprintf("%02d", $this->inventory->id).sprintf("%02d",$this->StuffType->id).sprintf("%02d",$this->Category->id).sprintf("%02d",$this->id);

        return $productCode;
    }
    public function Inventory()
    {
        return ($this->belongsTo('App\Models\Inventory', 'inventory_id'));
    }

    public function Brand()
    {
        return ($this->belongsTo('App\Models\Brands', 'brand_id'));
    }

    public function Category()
    {
        return ($this->belongsTo('App\Models\Category', 'category_id'));
    }

    public function StuffType()
    {
        return ($this->belongsTo(StuffType::class, 'stuffType_id'));
    }

    public function productsGallery()
    {
        return $this->hasMany(ProductsGallery::class, 'product_id');
    }

    public function productsColor()
    {
        return ($this->hasMany('App\Models\ProductsColor', 'product_id'));
    }

    public function productsRating()
    {
        return ($this->hasMany('App\Models\ProductsRating', 'product_id'));
    }

    public function Review()
    {
        return ($this->hasMany(Review::class, 'product_id'));
    }

    public function getProductId(){
        $id = 'TDX-';
        $id .= sprintf("%02d",$this->Category->id);
        $id .= sprintf("%02d",$this->inventory->id);
        $id .= sprintf("%02d",$this->id);

        return $id;
    }

    public function path()
    {
        return "/product/".$this->slug;
    }
}
