<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Review extends Model
{
    protected $fillable=[
        'user_id',
        'product_id',
        'name',
        'text',
        'positive',
        'negative',
        'confirmed',
        'replay_id',
        'product_score'
    ];

    public function Product(){
        return $this->belongsTo( Products::class,'product_id' );
    }

    public function User(){
        return $this->belongsTo( User::class,'user_id' );
    }
    
        public function replay(){
        return $this->hasMany(Review::class,'replay_id');
    }

    public function ReviewScore(){
        return $this->hasMany( ReviewScore::class,'review_id' );
    }

    public static function totalRate($product_id){

       $review = self::where('product_id',$product_id)->where('confirmed',1)->where('product_score','!=',null)->get();

       if(isset($review)){
           $sum = $review->sum('product_score');
           $count = count($review);
           if($count !== 0){
               $rate = $sum / $count;
               $rate = number_format((float)$rate, 1, '.', '');
           }else{
               $rate = null;
           }

       }else{
           $rate = null;
       }
       return $rate;
    }
}
