<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Cviebrock\EloquentSluggable\Sluggable;

class ProductsTecInfo extends Model
{
    use Sluggable;


    public function sluggable()
    {
        return [
            'slug' => [
                'source' => 'tec_info_key'
            ]
        ];
    }

    protected $table = 'products_tecinfo';

    protected $fillable = [
        'category_id',
        'tec_info_key',
        'code',
        'parent_id','hierarchy','status'
    ];

    public function Category()
    {
        return ($this->belongsTo('App\Models\Category', 'category_id'));

    }

    public function TecInfoProducts(){

        return $this->hasMany(TecInfoProduct::class,'tecInfo_id');
    }

    public static function getTecs($category,$status = 1){
        if(is_object($category)){
            $category = $category->id;
        }

        return self::where('category_id',$category)
            ->where('parent_id',0)
            ->where('status',$status)
            ->orderBy('hierarchy', 'asc')
            ->get();
    }

    public function getProductTecValue($product){

        if(is_object($product)){
            return $this->TecInfoProducts()->where('product_id',$product->id)->first();
        }
        return $this->TecInfoProducts()->where('product_id',$product)->first();
    }

}
