<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ProductsGallery extends Model
{
    protected $table = 'products_gallery';
    public $timestamps = true;
    public $fillable = ['image_path','image_path_m','image_path_th','created','product_id'];
    public function Product(){
        return $this->belongsTo( Products::class,'product_id' );
    }

    public function thumbPath(){
        return public_path() . "/" . $this->image_path_th;
    }

    public function mediumPath(){
        return public_path() . "/" . $this->image_path_m;

    }

    public function originalPath(){
        return  public_path() . "/" . $this->image_path;
    }
}
