<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;
use Illuminate\Database\Eloquent\SoftDeletes;

class ProductsColor extends Model
{
    use SoftDeletes;

    protected $dates=['deleted_at'];

    protected $table = 'products_color';

    protected $fillable = ['code','type','product_id','color_id','size_id','qty','base_sell_price','discount_sell_price','discount','priority','status','available'];

    public function Size(){
        return $this->belongsTo(Size::class,'size_id');
    }

    public function Product(){
        return $this->belongsTo(Products::class,'product_id' );
    }
    public function colorStore(){
        return($this->belongsTo(ColorStore::class,'color_id' ));
    }
    public function CartProduct(){
        return $this->hasMany(CartProduct::class,'product_color_id');
    }

    //error 800 = not available anymore
    //error 100 = its available
    //error 700 = its limited

    //check if the qty of product not to be 0 and its available
    public static function checkInventory($product_color_id){
        $product_color = ProductsColor::whereId($product_color_id)->first();
        $product = $product_color->Product()->first();

        if($product->checkAvailable()){
            if(isset($product_color)) {
                if ($product_color->checkAvailable()) {
                    return 100;
                }
            }
        }

        return 800;

    }

    //800 error is custom error(it means we dont have that product with that color any more)
    //700 error is custom error(it means the requested qty is more than our inventories qty)
    //check if we have those qty of product or not
    public static function checkInventoryLimit($product_color_id){

        if(Auth::check()){
            $cartItem = Cart::findCartProduct($product_color_id);
            $product_color = ProductsColor::whereId($product_color_id)->first();
            if(isset($cartItem)){
                if($cartItem->qty >= $product_color->qty || !$product_color->checkAvailable()){
                    $status = 700;
                }else{
                    $status = 100;
                }
            }else{
                $status = 100;
            }
        }else{
            $product_color = ProductsColor::whereId($product_color_id)->first();
            if(1 > $product_color->qty || !$product_color->checkAvailable()){
                $status = 700;
            }else{
                $status = 100;
            }
        }

        return $status;
    }

    public function getColorProductId(){
        $id = 'PRD-';
        $id .= sprintf("%02d",$this->Product->StuffType->id);
        $id .= sprintf("%02d",$this->Product->Category->id);
        $id .= sprintf("%02d",$this->Product->id);
        $id .= sprintf("%02d",$this->id);
        return $id;
    }

    public function User(){
        return $this->belongsToMany(User::class,'products_color_user','product_color_id','user_id');
    }

    public function checkAvailable(){
        $product = $this->Product()->first();
        if($product->checkAvailable()){
            if($this->status != 0){
                if($this->qty != 0 And $this->available != 0){
                    return true;
                }
            }
        }
        return false;
    }


}
