<?php

namespace App\Models;


use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Collection;

class Payment extends Model
{
    protected $fillable=[
        'cart_id' , 'package_price','shipment_price','total','discount_code_id','discount','payable_price','status','paid','transaction_id'
    ];

    public function Cart(){
        return($this->belongsTo(Cart::class,'cart_id' ));
    }

    public function DiscountCode(){
        return $this->belongsTo( DiscountCode::class,'discount_code_id' );
    }

    public function Transaction(){
        return $this->belongsTo( GateWayTransactionLog::class,'transaction_id' );
    }

    public function Profit(){
        return $this->hasMany(Profit::class,'payment_id');
    }

    public function PostLog(){
        return $this->hasOne(PostLog::class,'payment_id');
    }

    public function Address(){
        return $this->hasOne(PaymentAddress::class,'payment_id');
    }

    public function getProducts(){
        $cart = $this->cart()->first();

        $cartProducts = $cart->CartProduct()->get();
        $productCollection = new Collection();
        foreach ($cartProducts as $cartProduct){
            $productColor = $cartProduct->prodcutsColor()->first();
            $product = $productColor->Product()->first();
            $productCollection->push($product);
        }

        return $productCollection;
    }

}
