<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class NewestItem extends Model
{

    protected $table= "newest_items";

    protected $fillable = ['category_field_name' , 'category_id','status'];

    public function Category(){
        return $this->belongsTo(Category::class,'category_id' );
    }

    public function getItems(){
        return $this->where('status',1)->orderBy('category_field_name','asc')->get();
    }

    public function path(){
        return '/collections?sortby=1&status=0';
    }
}
