<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;

class MsMessage extends Model
{
    protected $fillable=['subject','body','status'];

    public function userMessagePivot(){
        return $this->hasMany(MsParticipant::class,'ms_id');
    }

    public function User(){
        return $this->belongsToMany(User::class,'ms_participants','ms_id','user_id');
    }


    public static function getAllMessages(){
        return MsParticipant::where('user_id',Auth::id())->latest()->get();
    }

    public static function getActiveMessages(){
        return MsParticipant::where('user_id',Auth::id())->where('seen',Null)->latest()->get();
    }

    public static function getActiveCount(){

        $messages = MsParticipant::where('user_id',Auth::id())->where('seen',Null)->get();


        $messages = $messages->reject(function ($value) {
            $ms = $value->Message()->first();
            if($ms->status == 0)
                return $value;
        });

        return $messages->count();
    }

}
