<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

use Cviebrock\EloquentSluggable\Sluggable;

class Filter extends Model
{
    use Sluggable;

    public function sluggable()
    {
        return [
            'slug' => [
                'source' => 'name'
            ]
        ];
    }

    protected $fillable=['title_id','name','tec_code','tec_id','url','priority','status'];


    public function FilterTitle(){
        return($this->belongsTo( FilterTitle::class,'title_id' ));
    }

    public function TecInfoProduct(){
        return $this->belongsTo( TecInfoProduct::class,'tec_id','tec_id' );
    }
}
