<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Cviebrock\EloquentSluggable\Sluggable;

class DynamicSubMenuSetting extends Model
{
    use Sluggable;


    public function sluggable()
    {
        return [
            'slug' => [
                'source' => 'sub_title'
            ]
        ];
    }

    protected $fillable=[
        'title_id',
        'sub_title',
        'priority',
        'title_type',
        'category_id',
        'brand_id',
        'tec_id',
        'tec_code',
        'url'
    ];

    public function path(){

        if($this->title_type == 4){

            return $this->url;
        }
            return url('/search?'.$this->url);

    }

    public function SubMenuTitle(){
        return $this->belongsTo( SubMenuTitle::class,'title_id' );
    }

    public function Category(){
        return $this->belongsTo( Category::class,'category_id' );

    }

    public function Brand(){
        return $this->belongsTo( Brands::class,'brand_id' );

    }

    public function TecInfoProduct(){
        return $this->belongsTo( TecInfoProduct::class,'tec_id','tec_id' );

    }

}
