<?php

namespace App\Models;
use Illuminate\Database\Eloquent\Model;
use Cviebrock\EloquentSluggable\Sluggable;

class DynamicSubMenu extends Model
{
    use Sluggable;


    public function sluggable()
    {
        return [
            'slug' => [
                'source' => 'cat_name'
            ]
        ];
    }

    protected $fillable=['name','category_id','dynamic_menu_id','status','cat_name','url','type'];


    public function path(){
        $url = '';
        if($this->type == 1){
            $url .= url('/category/'.$this->slug);
        }elseif ($this->type == 2){
            $url .= $this->url;

        }
        return $url;
    }

    public function SubMenuTitle(){
        return($this->hasMany( SubMenuTitle::class,'sub_menu_id' ));
    }

    public function DynamicMenu(){
        return $this->belongsTo( DynamicMenu::class,'dynamic_menu_id' );
    }

    public function Category(){
        return($this->belongsTo( Category::class,'category_id' ));
    }
}
