<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Cviebrock\EloquentSluggable\Sluggable;

class DynamicMenu extends Model
{

    use Sluggable;


    public function sluggable()
    {
        return [
            'slug' => [
                'source' => 'stuffType_name'
            ]
        ];
    }

    protected $fillable=['name','status','stuffType_name','stuffType_id','type','url'];

    public function path(){
        $url = '';
        if($this->type == 1){
            $url .= url('product_type/'. $this->slug);
        }elseif($this->type == 2){
            $url .= $this->url;
        }
        return $url;
    }

    public function MenuSlots(){
        return $this->hasOne( DynamicMenuSlot::class,'dynamic_menu_id' );
    }

    public function DynamicSubMenu(){
        return($this->hasMany( DynamicSubMenu::class,'dynamic_menu_id' ));
    }

    public function StuffType(){
        return($this->belongsTo( StuffType::class,'stuffType_id' ));
    }
}
