<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class DiscountCode extends Model
{
    use SoftDeletes;

    protected $dates =['valid_time','deleted_at'];

    protected $fillable=[
        'discount_type','code','percentage','amount','valid_time','times_left','price_top','price_down'
    ];

    public function Payment(){
        return $this->hasMany( DiscountCode::class,'discount_code_id' );
    }

}
