<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Cviebrock\EloquentSluggable\Sluggable;

class ColorStore extends Model
{
    use Sluggable;


    public function sluggable()
    {
        return [
            'slug' => [
                'source' => 'colorName'
            ]
        ];
    }

    public $timestamps = true;
    protected $table = 'color_store';

    protected $fillable = ['colorName','colorCode'];

    public function productsColor(){
        return($this->hasMany( 'App\Models\ProductsColor','color_id' ));
    }

}