<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Cviebrock\EloquentSluggable\Sluggable;

class Category extends Model
{
    use Sluggable;


    public function sluggable()
    {
        return [
            'slug' => [
                'source' => 'category'
            ]
        ];
    }
    /**
     * The database table used by the model.
     *
     * @var string
     */
    public $timestamps = true;
    protected $table = 'category' ;
    protected $primaryKey = 'id';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = ['category' , 'stuffType_id','type'];

    public function path(){
        return "/category/$this->slug";
    }

    public function Products(){
        return($this->hasMany( 'App\Models\Products','category_id' ));
    }

    public function NewestItemsProducts($item_id){

        $NewestItemsProducts =  NewestItem::whereId($item_id)->first()->Category->Products()->where('status',1)->availableFirst()->latest()->take(8)->get();

        return $NewestItemsProducts;
    }

    public function AccessoriesProducts($item_id){

        $access =  Accessory::whereId($item_id)->first()->Category->Products()->where('status',1)->latest()->take(8)->get();

        return $access;
    }

    public function BestSellersProducts($item_id){

        $bestSellers =  BestSeller::whereId($item_id)->first()->Category->Products()->where('status',1)->availableFirst()->orderBy('sold_count','desc')->take(8)->get();

        return $bestSellers;
    }

    public function FilterTitle(){
        return($this->hasMany( FilterTitle::class,'category_id' ));
    }

    public function StuffType(){
        return($this->belongsTo('App\Models\StuffType','stuffType_id' ));
    }

    public function SubMenu(){
        return($this->hasMany( DynamicSubMenu::class,'category_id' ));
    }

    public function NewestItems(){
        return($this->hasMany( 'App\Models\NewestItem','category_id'));
    }

    public function SubMenuSetting(){
        return $this->hasMany( Category::class,'category_id' );

    }

    public function TecInfo(){
        return($this->hasMany(ProductsTecInfo::class,'category_id' ));
    }


    //---------------------------------------\\

    public function Size(){
        return $this->hasMany(Size::class,'category_id');
    }
}
