<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CartProduct extends Model
{
    use SoftDeletes;

    protected $fillable = ['cart_id','product_color_id','qty','base_sell_price','discount_sell_price','discount','total','sell_date'];

    protected $dates=['sell_date'];

    public function Cart(){
        return $this->belongsTo(Cart::class,'cart_id');
    }

    public function ProductColor(){
        return $this->belongsTo(ProductsColor::class,'product_color_id');
    }

    public function productColorCode(){
        return $this->ProductColor()->first()->code;
    }

    public function productCode(){
        return $this->ProductColor()->first()->Product()->first()->code;
    }

    public static function getProduct($cartProductId){

        $cartProduct = CartProduct::whereId($cartProductId)->first();

        return $cartProduct->ProductColor()->first()->Product()->first();
    }

    public function getProduct2(){

        return $this->ProductColor()->first()->Product()->first();
    }

}
