<?php

namespace App\Models;

use App\Events\PurchaseSuccessfulEvent;
use Illuminate\Contracts\Cookie\Factory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Cookie;
use Illuminate\Support\Facades\Event;
use Illuminate\Support\Facades\Validator;

class Cart extends Model
{
    protected $fillable = ['user_id','paid','confirmed'];

    public function User(){
        return $this->belongsTo(User::class,'user_id');
    }

    public function CartProduct(){
        return $this->hasMany(CartProduct::class,'cart_id');
    }

    public function Payment(){
        return $this->hasOne(Payment::class,'cart_id');
    }

    public function Address(){
        return $this->hasOne(PaymentAddress::class,'payment_id');
    }


    public function isConfirmed(){
        if($this->confirmed == 1){
            return true;
        }
        return false;
    }

    public function isActive(){
        $payment = $this->Payment()->first();

        if($this->paid == 0 && !$this->isConfirmed() && !is_null($payment)){
            return true;
        }

        return false;
    }

    public static function getUnConfirmedCarts(){
       $carts = self::where('confirmed',0)->latest()->get();

        $carts = $carts->filter(function ($cart){
           $payment = $cart->Payment()->first();
           if(!is_null($payment)){
               return true;
           }else{
               return false;
           }
       });

       return $carts;
    }

    public static function getConfirmedCarts(){
       $carts = self::where('confirmed',1)->latest()->get();

       return $carts;
    }
    //------------- cart Ceate/Finding---------\\
    public static function createCart(){

        $cart = self::create([
            'user_id' => Auth::user()->id,
            'paid' => 0,
            'payment' => null,
        ]);
        return $cart;
    }

    public static function findCart(){

        if(Auth::check()){
            $cart = self::where('user_id',Auth::id())->where('paid',0)->first();

        }else{
            $cart = null;
        }

        return $cart;
    }

    public static function encrypt_decrypt($action,$cartId){
        $output = false;
        $encrypt_method = "AES-256-CBC";
        $secret_key = '@SalarRockTyphoonGalaxySi9000';
        $secret_iv = '@SalarRockTyphoonGalaxySi9000...';
        // hash
        $key = hash('sha256', $secret_key);

        // iv - encrypt method AES-256-CBC expects 16 bytes - else you will get a warning
        $iv = substr(hash('sha256', $secret_iv), 0, 16);
        if ( $action == 'encrypt' ) {
            $output = openssl_encrypt($cartId, $encrypt_method, $key, 0, $iv);
            $output = base64_encode($output);
        } else if( $action == 'decrypt' ) {
            $output = openssl_decrypt(base64_decode($cartId), $encrypt_method, $key, 0, $iv);
        }
        return $output;
    }


    public static function cartItems(){
        $cart = self::findCart();

        if(!is_null($cart)){
            $cartItems = $cart->CartProduct()->get();
        }else{
            $cartItems = null;
        }


        return $cartItems;
    }

    //real items means its get the data from productColor table / not from cartproduct table
    public static function cartRealItemsCookie(){

        //get cookie
        $cookie_data = Cookie::get('cart');
        //turn jsone cookie into normal array
        $cookie_data = stripslashes($cookie_data);
        $cookieCartItems = json_decode($cookie_data, true);

        $cartItems = array();
        if(isset($cookieCartItems)){
            foreach ($cookieCartItems as $productId){
                $cartItems[] = ProductsColor::whereId($productId)
                    ->where('status','!=',0)
                    ->where('available','!=',0)
                    ->first();
            }
        }else{
            $cartItems = null;
        }


        return $cartItems;
    }

    public static function cartRealItemsDB(){

        $cart = self::findCart();
        if(!is_null($cart)){
            $cartItems = $cart->CartProduct()->get();
        }
        $cartProducts = array();
        if(isset($cartItems)){
            foreach($cartItems as $item){
                $cartProducts [] = ProductsColor::whereId($item->product_color_id)
                    ->where('status','!=',0)
                    ->where('available','!=',0)
                    ->first();
            }
        }else{
            $cartProducts = null;
        }

        return $cartProducts;
    }

    public static function cartRealItems(){

        if(Auth::check()){
            $cartItems =  self::cartRealItemsDB();
        }else{
            $cartItems = self::cartRealItemsCookie();
        }


        return $cartItems;
    }

//---------- product  add\find\remove---------\\

    public static function addToCartAdmin($cart,$productId)
    {
        $validator = Validator::make(['id'=>$productId],['id'=>'exists:products_color,id']);

        if(!$validator->fails()){
            $product = ProductsColor::whereId($productId)
                ->where('status','!=',0)
                ->where('available','!=',0)
                ->first();
            if(isset($product)){
                if (!is_null($cart)) {
                    $cart->confirmed = 0;
                    $cart->save();

                    $cartProduct = CartProduct::where('cart_id',$cart->id)->where('product_color_id', $productId)->first();

                    if(isset($cartProduct)) {
                        $cartProduct->update([
                            'cart_id' => $cart->id,
                            'product_color_id' => $productId,
                            'qty' => $cartProduct->qty + 1,
                            'base_sell_price' => $product->base_sell_price,
                            'discount_sell_price' => $product->discount_sell_price,
                            'discount' => $product->discount * ($cartProduct->qty + 1),
                            'total' => $product->discount_sell_price * ($cartProduct->qty + 1),
                        ]);
                    } else {
                        CartProduct::create([
                            'cart_id' => $cart->id,
                            'product_color_id' => $productId,
                            'qty' => 1,
                            'base_sell_price' => $product->base_sell_price,
                            'discount_sell_price' => $product->discount_sell_price,
                            'discount' => $product->discount,
                            'total' => $product->discount_sell_price,
                        ]);
                    }
                }else{
                    $cart = self::createCart();
                    CartProduct::create([
                        'cart_id' => $cart->id,
                        'product_color_id' => $productId,
                        'qty' => 1,
                        'base_sell_price' => $product->base_sell_price,
                        'discount_sell_price' => $product->discount_sell_price,
                        'discount' => $product->discount,
                        'total' => $product->discount_sell_price,
                    ]);
                }
            }

        }
    }
//add
    public static function addToCart($cart,$productId){

        $validator = Validator::make(['id'=>$productId],['id'=>'exists:products_color,id']);

        if(!$validator->fails()){
            $product = ProductsColor::whereId($productId)
                ->where('status','!=',0)
                ->where('available','!=',0)
                ->first();
            if(isset($product)){
                if (!is_null($cart)) {
                    $cart->confirmed = 0;
                    $cart->save();

                    $cartProduct = CartProduct::where('cart_id',$cart->id)->where('product_color_id', $productId)->first();

                    if(isset($cartProduct)) {
                        $cartProduct->update([
                            'cart_id' => $cart->id,
                            'product_color_id' => $productId,
                            'qty' => $cartProduct->qty + 1,
                            'base_sell_price' => $product->base_sell_price,
                            'discount_sell_price' => $product->discount_sell_price,
                            'discount' => $product->discount * ($cartProduct->qty + 1),
                            'total' => $product->discount_sell_price * ($cartProduct->qty + 1),
                        ]);
                    } else {
                        CartProduct::create([
                            'cart_id' => $cart->id,
                            'product_color_id' => $productId,
                            'qty' => 1,
                            'base_sell_price' => $product->base_sell_price,
                            'discount_sell_price' => $product->discount_sell_price,
                            'discount' => $product->discount,
                            'total' => $product->discount_sell_price,
                        ]);
                    }
                }else{
                    $cart = self::createCart();
                    CartProduct::create([
                        'cart_id' => $cart->id,
                        'product_color_id' => $productId,
                        'qty' => 1,
                        'base_sell_price' => $product->base_sell_price,
                        'discount_sell_price' => $product->discount_sell_price,
                        'discount' => $product->discount,
                        'total' => $product->discount_sell_price,
                    ]);
                }
            }

        }
    }

    public static function addToCartInLogin(){

        $cart = self::findCart();
        $cartItems = self::cartItems();
        $cart_product_ids = array();
        //push carts form db items id onto array
        if(!is_null($cartItems)){
            foreach ($cartItems as $items){
                array_push($cart_product_ids ,$items->product_color_id );
            }
        }
        //get cookie
        $cookie_data = Cookie::get('cart');
        //turn jsone cookie into normal array
        $cookie_data = stripslashes($cookie_data);
        $data = json_decode($cookie_data, true);

//check if the id in cookie is in db or not ->if yes nothing happening ->if not added to existing cart
        if(isset($data)){
            foreach ($data as $cookie_id){

                if(!in_array($cookie_id,$cart_product_ids)){
                    self::addToCart($cart,$cookie_id);
                }
            }

            //unset cookie after adding to db
            if (isset($cookie_data)) {
                unSet($_COOKIE['cart']);
                setcookie('cart', '', time() - 3600);
            }
        }

    }

    public static function addToCartInLogout($cookie){

        $cartItems = self::cartItems();

        if(!is_null($cartItems)){
            $colorProducts = array();
            foreach ($cartItems as $item){

                $colorProducts[] = $item->ProductColor()->first();
            }
            $data = array();
            foreach ($colorProducts as $product){
                array_push($data, $product->id);
            }
            $data = array_unique($data);
            $data = json_encode($data);
            $cookie->queue($cookie->make('cart', $data, 129600));
        }

    }

//find
    public static function findCartProduct($productColorId){
        $cart = self::findCart();

        if(!is_null($cart)){
            $cartItem = $cart->CartProduct()->where('product_color_id',$productColorId)->first();
        }else{
            $cartItem = null;
        }

        return $cartItem;
    }

//remove
    public static function removeFromCartDB($product_id){

        $cartProduct = self::findCartProduct($product_id);
        if(isset($cartProduct)){
            try{
                CartProduct::whereId($cartProduct->id)->forceDelete();
            }catch(\Illuminate\Database\QueryException $e){

            }
        }
    }

    public static function removeFromCartCookie($product_id,$cookie){

        $data = array();
        $cookie_data = Cookie::get('cart');
        //1)
        if (isset($cookie_data)) {
            //2)
            if(!is_array($cookie_data))
            {
                //3)
                $cookie_data = stripslashes($cookie_data);
                $data = json_decode($cookie_data, true);

                if (($key = array_search($product_id, $data)) !== false) {
                    unset($data[$key]);
                }

            }
        }
        //6)
        $data = array_unique($data);
        //7)
        $data2 = json_encode($data);
        //8)
        $cookie->queue($cookie->make('cart', $data2, 129600));

        return $data;
    }
//--------- price and billing --------- \\
    public static function cartTotalPrice(){

        $cart = self::findCart();
        if(isset($cart)){
            $cartItems = $cart->CartProduct()->get();

            $totalPrice = $cartItems->sum('total');
        }else{
            $totalPrice = 0;
        }

        return $totalPrice;
    }

    public static function payCart($transID){

        $transaction =  GateWayTransactionLog::where('transaction_id',$transID)->first();

        if(isset($transaction)){
            $cart = self::findCart();
            $payment = $cart->Payment()->first();
            if($transaction->result_code == 100 || $transaction->result_code == 101){
                $cart->update([
                    'paid' => 1,
                ]);

                $payment->update([
                    'paid' => 1,
                    'status' => 1,
                    'transaction_id' => $transaction->id
                ]);

                Event::fire(new PurchaseSuccessfulEvent($payment));

                return $payment->id;
            }else{
                $payment->update([
                    'transaction_id' => $transaction->id
                ]);
            }
        }
        return false;
    }

//------------remove Or deleting------------\\
    public static function removeCart(){
        $cart = self::findCart();
        if(!is_null($cart)){
            self::removeCartDatabase();
        }else{
            self::removeCartCookie();
        }
    }

    public static function removeCartDatabase(){
        $cart = self::findCart();
        if(!is_null($cart)){
            deleteSimple(self::whereId($cart->id)->where('paid',0)->first());
        }
    }

    public static function removeCartCookie(){
        $cookie_data = Cookie::get('cart');
        if (isset($cookie_data)) {
            unSet($_COOKIE['cart']);
            setcookie('cart', '', time() - 3600);
        }
    }


    public static function checkCart(Factory $cookie){

        if(Auth::check()){
            $cartItems = Cart::cartItems();
            if(isset($cartItems)) {
                foreach ($cartItems as $cartItem) {
                    self::checkCartProductDB($cartItem->product_color_id);
                }
            }

        }else{
            //get cookie
            $cookie_data = Cookie::get('cart');
            //turn jsone cookie into normal array
            $cookie_data = stripslashes($cookie_data);
            $cookieCartItems = json_decode($cookie_data, true);
            if(isset($cookieCartItems)){
                foreach ($cookieCartItems as $productColorId){
                    self::checkCartProductCookie($productColorId,$cookie);

                }
            }

        }

    }

    public static function checkCartProductDB($productColorId){
        $status = ProductsColor::checkInventory($productColorId);
        if ($status == 800)
            self::removeFromCartDB($productColorId);

        return $status;
    }

    public static function checkCartProductCookie($productColorId,Factory $cookie){
        $status = ProductsColor::checkInventory($productColorId);
        if ($status == 800)
            self::removeFromCartCookie($productColorId, $cookie);

        return $status;
    }
    
    public function updateCart()
    {
        $cartProducts = $this->CartProduct()->get();

        $status = 0;
        foreach ($cartProducts as $cartProduct) {

            $product = $cartProduct->ProductColor->Product;
            $productColor = $cartProduct->ProductColor;


            if ($product->qty > 0 && $product->status == 1 && $product->available == 1) {
                if ($cartProduct->qty > $productColor->qty) {
                    $cartProduct->update([
                        'qty' => $productColor->qty,
                    ]);
                    $status++;
                }
                if ($cartProduct->total != $productColor->discount_sell_price * ($cartProduct->qty)){
                    $cartProduct->update([
                        'base_sell_price' => $productColor->base_sell_price,
                        'discount_sell_price' => $productColor->discount_sell_price,
                        'discount' => $productColor->discount * ($cartProduct->qty),
                        'total' => $productColor->discount_sell_price * ($cartProduct->qty),
                    ]);
                    $status++;
                }


            } else {
                $cartProduct->delete();
                if ($cartProduct->Cart->CartProduct->isEmpty()) {
                    $this->removeCartDatabase();
                }
                $status++;
            }
        }

        if ($status > 0) {
            return false;
        } else {
            return true;
        }
    }




}
