<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Cviebrock\EloquentSluggable\Sluggable;

class Brands extends Model
{

    use Sluggable;


    public function sluggable()
    {
        return [
            'slug' => [
                'source' => 'brandName'
            ]
        ];
    }

    /**
     * The database table used by the model.
     *
     * @var string
     */
    public $timestamps = true;
    protected $table = 'brands' ;
    protected $primaryKey = 'id';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = ['brandName'];

    public function products(){
        return($this->hasMany( 'App\Models\Products','brand_id' ));
    }

    //-------------search models---------------------\\
    public function Brand_Product(){
        return($this->hasMany( 'App\Models\Search\brand_product','brand_id' ));
    }

    public function Category_Product(){
        return($this->hasMany( 'App\Models\Search\cat_product','category_id' ));
    }
    public function Inventory_Product(){
        return($this->hasMany( 'App\Models\Search\inv_product','inventory_id' ));
    }
//---------------------------------------\\
    public function SubMenuSetting(){
        return($this->hasMany( DynamicSubMenuSetting::class,'brand_id' ));
    }

}
