<?php

namespace App\Models;
use Cviebrock\EloquentSluggable\Sluggable;

use Illuminate\Database\Eloquent\Model;

class ArticleCategory extends Model
{
    use Sluggable;

    public $timestamps = true;
    protected $fillable = ['name', 'slug',];

    public function sluggable()
    {
        return [
            'slug' => [
                'source' => 'name'
            ]
        ];
    }

    public function path()
    {
        return "/article/category/$this->slug";
    }
}
