<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Cviebrock\EloquentSluggable\Sluggable;

class Article extends Model
{
    use Sluggable;
    protected $table = 'articles';
    public $timestamps = true;
    protected $fillable = ['category_id','title', 'description', 'body', 'image_path','thumb_path','user_id', 'tags', 'slug', 'view_count', 'status'];

    public function sluggable()
    {
        return [
            'slug' => [
                'source' => 'title'
            ]
        ];
    }

    public function path()
    {
        return "/article/$this->slug";
    }

    public function category(){
        return $this->belongsTo(ArticleCategory::class,'category_id');
    }

    public function user()
    {
        return $this->belongsTo(User::class,'user_id');
    }

    public function getImage(){
        if(!is_null($this->thumb_path)){
            return '<img src="'.url('/').$this->thumb_path.'" class="img-responsive front" alt="'.$this->title.'" title="'.$this->title.'">';
        }
        return '<img src="'.path_to_images('defaults/default.png').'"  class="img-responsive front"  style="opacity: 0.6" alt="'.$this->title.'" title="'.$this->title.'" >';
    }


}
