<?php namespace App\ModelFilters;

use App\Helpers\Choices;
use App\Models\TecInfoProduct;
use EloquentFilter\ModelFilter;


class ProductsFilter extends ModelFilter
{

    use Choices;

    /**
     * Related Models that have ModelFilters as well as the method on the ModelFilter
     * As [relationMethod => [input_key1, input_key2]].
     *
     * @var array
     */
    public $relations = [];

    public function setup()
    {
        if(!request()->has('sortby')){
            $this->availableFirst();
        }
        $this->activeProducts();

    }

    public function category($categories){
        return $this->where(function ($query) use ($categories) {
            foreach ($categories as $category_id) {
                $query = $query->orWhere('category_id', $category_id);
            }
            return $query;
        });
    }

    public function brand($brands){
        return $this->where(function ($q) use ($brands) {
            foreach ($brands as $brand_id) {
                if (!request()->ajax()) {
                    $this->choicesMade('brand', $brand_id);
                }
                $q = $q->orWhere('brand_id', $brand_id);
            }
            return $q;
        });
    }

    public function status($status){
        if ($status == 0) {
            return $this;

        }else{
            if (!request()->ajax()) {
                $this->choicesMade('status', 1);
            }
            return $this->where(function ($q) {
                $q = $q->where('products.qty', '!=', 0)
                    ->where('products.available',1);
                return $q;
            });
        }
    }

    public function price($price){
        $price = explode(',', $price);
        if(is_array($price)){
            if (!request()->ajax()) {
                $this->choicesMadePrice($price, reset($this->input('category')));
            }
            return $this->whereBetween('products.base_sell_price', [$price[0], $price[1]]);

        }else{
            return $this;
        }
    }

    public function sortBy($sort){
        switch ($sort) {
            case 1:
                return  $this->latest();
                break;
            case 2:
                return $this->orderBy('view_count', 'desc');
                break;
            case 3:
                return $this->orderBy('sold_count', 'desc');
                break;
            case 4:
                return $this->orderBy('products.base_sell_price', 'asc');
                break;
            case 5:
                return $this->orderBy('products.base_sell_price', 'desc');
                break;
            default:
                return  $this->latest();
                break;
        }
    }

    public function color($colors)
    {

        return  $this->related('productsColor', function($query) use ($colors) {
            return $query->whereStatus(1)->where(function ($q) use ($colors) {
                foreach ($colors as $color_id) {
                    if (!request()->ajax()) {
                        $this->choicesMade('color', $color_id);
                    }
                    $q = $q->orWhere('color_id', $color_id);
                }
                return $q;
            });
        });
    }

    public function tecInfo($tecInfos){

        return $this->related('getTecInfo', function($query) use ($tecInfos) {
            $code = $tecInfos['key'];
            unset($tecInfos['key']);

            $query = $query->where(function ($q) use ($code,$tecInfos) {

                foreach ($tecInfos as $key => $tecId) {

                    if (!request()->ajax()) {
                        $this->choicesMade('tecInfo', $code,$tecId);
                    }
                    $value = TecInfoProduct::where('tec_id',$tecId)->first();

                    $q = $q->orWhere('value',  $value->value );
                }
                return $q;
            });

            return $query;
        });

    }

}
