<?php

namespace App\Listeners;

use App\Events\inventoryCheckoutEvent;
use App\Events\ProfitEvent;
use App\Models\Cart;
use Carbon\Carbon;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Support\Facades\Event;

class inventoryCheckoutListener
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  inventoryCheckoutEvent  $event
     * @return void
     */
    public function handle(inventoryCheckoutEvent $event)
    {
        $cart = $event->cart ;
        if(!is_null($cart)){
            $cartItems = $cart->CartProduct()->get();
            if(isset($cartItems)){
                foreach ($cartItems as $item){
                    $item->sell_date = Carbon::now();
                    $item->save();
                    $productColor = $item->ProductColor()->first();
                    if($productColor->qty !== 0){
                        $productColor->qty =  $productColor->qty - $item->qty;
                        $productColor->save();
                    }
                    $product = $productColor->Product()->first();
                    if($product->qty !== 0) {
                        $product->qty = $product->qty - $item->qty;
                        $product->sold_count = $product->sold_count + $item->qty;
                        $product->save();
                    }
                    Event::fire(new ProfitEvent($cart,$cartItems,$item,$product));
                }
            }

        }
    }
}
