<?php

namespace App\Listeners;

use App\Events\ShipmentEvent;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Support\Facades\Auth;

class ShipmentListener
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  ShipmentEvent  $event
     * @return integer
     */
    public function handle(ShipmentEvent $event)
    {
        $cart = $event->cart;

        $cartItems = $cart->CartProduct()->get();

        $totalWeight = 0;
        foreach ($cartItems as $item){
            $colorProduct = $item->ProductColor()->first();
            $product = $colorProduct->Product()->first();

            $totalWeight += $product->weight * $item->qty;

        }
        $user = Auth::user();

        $shipmentCost = $this->shipmentCost($totalWeight,$user->state);

//        if($user->city == 'ارومیه'){
//            $shipmentCost = 0;
//        }
$shipmentCost=0;

       return $shipmentCost;

    }

    protected function shipmentCost($weight,$province){

        if($province == 'آذربایجان غربی'){
            switch ($weight){
                case $weight <= 500:
                    $shipmentCost  = 5000;
                    break;
                case $weight > 500 && $weight <= 1000:
                    $shipmentCost  = 6500;
                    break;
                case $weight > 1000 && $weight <= 2000:
                    $shipmentCost  = 8600;
                    break;
                case  $weight > 2000:
                    $extraWeight = $weight - 2000;

                    $extraCost = $extraWeight /1000 * 2100;

                    $shipmentCost = 8600 + $extraCost;
                    break;
            }
        }else{
            switch ($weight){
                case $weight <= 500:
                    $shipmentCost = 6000;
                    break;
                case $weight > 500 && $weight <= 1000:
                    $shipmentCost = 8000;
                    break;
                case $weight > 1000 && $weight <= 2000:
                    $shipmentCost = 10500;
                    break;
                case  $weight > 2000:
                    $extraWeight = $weight - 2000;

                    $extraCost = $extraWeight /1000 * 2100;

                    $shipmentCost = 10500 + $extraCost;
                    break;
            }
        }

        return $shipmentCost;
    }
}
