<?php

namespace App\Listeners;

use App\Events\SearchUpdateIndex;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use TeamTNT\TNTSearch\TNTSearch;

class SearchUpdateIndexListener
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  SearchUpdateIndex  $event
     * @return void
     */
    public function handle(SearchUpdateIndex $event)
    {
        $product = $event->products;


        $tnt = new TNTSearch;

        $driver = config('database.default');
        $config = config('scout.tntsearch') + config("database.connections.{$driver}");


        $tnt->loadConfig($config);
        $tnt->selectIndex("category.index");

        $index = $tnt->getIndex();


        $index->update($product->id,['id' => $product->id, 'category_id' => $product->category_id]);

        //********************
        $tnt->selectIndex("brand.index");

        $index = $tnt->getIndex();

        $index->update($product->id,['id' => $product->id, 'brand_id' => $product->brand_id]);


    }
}
