<?php

namespace App\Listeners;

use App\Events\SearchIndex;
use TeamTNT\TNTSearch\Indexer\TNTIndexer;
use TeamTNT\TNTSearch\TNTSearch;

class SearchIndexListener
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  SearchIndex $event
     * @return void
     */
    public function handle(SearchIndex $event)
    {
        $product = $event->products;


        $tnt = new TNTSearch;

        $driver = config('database.default');
        $config = config('scout.tntsearch') + config("database.connections.{$driver}");


        $tnt->loadConfig($config);
        $tnt->selectIndex("category.index");

        $index = $tnt->getIndex();


        $index->insert(['id' => $product->id, 'category_id' => $product->category_id]);

        //********************
        $tnt->selectIndex("brand.index");

        $index = $tnt->getIndex();

        $index->insert(['id' => $product->id, 'brand_id' => $product->brand_id]);

    }
}
