<?php

namespace App\Listeners;

use App\Events\ResetPassEvent;
use App\Helpers\SmsTemplates;
use App\Models\PasswordReset;
use Illuminate\Support\Facades\Validator;
use phplusir\smsir\Smsir;

class ResetPassSmsListener
{
    use SmsTemplates;
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  ResetPassEvent $event
     * @return void
     */
    public function handle(ResetPassEvent $event)
    {
        $user = $event->user;

        $activationKey = $this->randomId();

        PasswordReset::updateOrCreate(
            ['user_id' => $user->id],
            [
                'mobile' => $user->mobile,
                'sms_code' => $activationKey
            ]
        );

        $template = $this->resetPassTemplate();


        Smsir::ultraFastSend(['VerificationCode' => $activationKey], $template->id, $user->mobile);
    }

    protected function randomId()
    {

        $code = random_int(11111, 99999);

        $validator = Validator::make(['sms_code' => $code], ['sms_code' => 'unique:password_resets']);

        if ($validator->fails()) {
            $this->randomId();
        }

        return $code;
    }
}
