<?php

namespace App\Listeners;

use App\Events\RegisterEvent;
use App\Helpers\SmsTemplates;
use App\Models\UserActivationSms;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Support\Facades\Validator;
use phplusir\smsir\Smsir;

class RegisterSmsListener
{
    use SmsTemplates;
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  RegisterEvent $event
     * @return void
     */
    public function handle(RegisterEvent $event)
    {
        $user = $event->user;

        $activationKey = $this->randomId();

        UserActivationSms::updateOrCreate(
            ['mobile' => $user->mobile,],
            ['activationCode' => $activationKey,]
        );

        $template = $this->registerSmsTemplate();

        Smsir::ultraFastSend(['VerificationCode' => $activationKey], $template->id, $user->mobile);
    }

    protected function randomId()
    {

        $code = random_int(11111, 99999);

        $validator = Validator::make(['activationCode' => $code], ['activationCode' => 'unique:user_activation_sms']);

        if ($validator->fails()) {
            $this->randomId();
        }

        return $code;
    }
}
