<?php

namespace App\Listeners;

use App\Events\PurchaseSendByPostEvent;
use App\Helpers\SmsTemplates;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Morilog\Jalali\jDate;
use phplusir\smsir\Smsir;

class PurchasePostSms
{
    use SmsTemplates;
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  PurchaseSendByPostEvent  $event
     * @return void
     */
    public function handle(PurchaseSendByPostEvent $event)
    {
        $payment = $event->payment;
        $post = $event->post;

        $date = jDate::forge('now')->format('datetime') ;

        $userAddress = $payment->Address()->first();

        $user = $userAddress->User()->first();

        $template = $this->purchasePostTemplate();

        Smsir::ultraFastSend(['post_ref_id' => $post->post_code,'ref_id' => $payment->id,'date' => $date], $template->id, $user->mobile);
    }
}
