<?php

namespace App\Listeners;

use App\Events\PurchaseSendByPeykEvent;
use App\Helpers\SmsTemplates;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Morilog\Jalali\jDate;
use phplusir\smsir\Smsir;

class PurchasePeykSms
{
    use SmsTemplates;
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  PurchaseSendByPeykEvent  $event
     * @return void
     */
    public function handle(PurchaseSendByPeykEvent $event)
    {
        $payment = $event->payment;

        $date = jDate::forge('now')->format('datetime') ;

        $userAddress = $payment->Address()->first();

        $user = $userAddress->User()->first();

        $template = $this->purchasePeykTemplate();

        Smsir::ultraFastSend(['ref_id' => $payment->id,'date' => $date], $template->id, $user->mobile);
    }
}
