<?php

namespace App\Listeners;

use App\Events\PurchaseSuccessfulEvent;
use App\Helpers\SmsTemplates;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Morilog\Jalali\jDate;
use phplusir\smsir\Smsir;

class PurchaseCostumerSms
{
    use SmsTemplates;
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  PurchaseSuccessfulEvent  $event
     * @return void
     */
    public function handle(PurchaseSuccessfulEvent $event)
    {
        $payment = $event->payment;

        $date = jDate::forge('now')->format('datetime') ;

        $userAddress = $payment->Address()->first();

        $user = $userAddress->User()->first();

        $template = $this->purchaseCostumerTemplate();

        Smsir::ultraFastSend(['ref_id' => $payment->id,'date' => $date], $template->id, $user->mobile);
    }
}
