<?php

namespace App\Listeners;

use App\Events\ProfitEvent;
use App\Models\Profit;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;

class ProfitListener
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  ProfitEvent  $event
     * @return void
     */
    public function handle(ProfitEvent $event)
    {
        $payment            = $event->cart->Payment()->first();
        $buyPrice           = $event->product->buy;
        $sellPrice          = $event->cartProduct->discount_sell_price;
        $total_qty          = $event->cartProducts->sum('qty');
        $payable_price      = $payment->payable_price;
        $discount_sell      = round($payable_price / $total_qty , 2, PHP_ROUND_HALF_DOWN);
        $singleProfit       = $discount_sell - $buyPrice;
        $totalProfit        = ($discount_sell - $buyPrice) * $event->cartProduct->qty;
        $p_grossProfit      = round($singleProfit / $discount_sell * 100 , 2, PHP_ROUND_HALF_DOWN);
        $p_grossMargin      = round(100 * $singleProfit / $buyPrice, 2, PHP_ROUND_HALF_DOWN);

        Profit::create([
            'payment_id'        => $payment->id,
            'sell'              => $sellPrice,
            'discount_sell'     => $discount_sell,
            'buy'               => $buyPrice,
            'qty'               => $event->cartProduct->qty,
            'single_profit'     => $singleProfit,
            'gross_profit'      => $totalProfit,
            'p_gross_profit'    => $p_grossProfit,
            'p_gross_margin'    => $p_grossMargin
        ]);

    }
}
