<?php

namespace App\Listeners;

use App\Events\CartSmsEvent;
use App\Helpers\SmsTemplates;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Morilog\Jalali\jDate;
use phplusir\smsir\Smsir;

class CartSmsListener
{
    use SmsTemplates;
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  CartSmsEvent  $event
     * @return void
     */
    public function handle(CartSmsEvent $event)
    {
        $user = $event->cart->User()->first();
        $payment = $event->cart->Payment()->first();
        $date = jDate::forge('now')->format('datetime') ;

        $template = $this->cartSmsTemplate($payment,$date);

        Smsir::ultraFastSend2(['ref_id' => $payment->id,'date' => $date], $template->id, $user->mobile,$template->message);
    }
}
