<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class registerRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'userName' => 'required|max:60|string',
            'mobileNum' => ['required','digits:11','regex:/^(0|0098|\\+98|98)?(9[0-9]{9})$/'],
            'email'=>'required|unique:users|email',
            'password'=>'required|max:60|min:6|confirmed',
            'password_confirmation' => 'max:60|min:6',
        ];
    }

    public function messages() {
        return [

            'mobileNum.required' => 'لطفا شماره تلفن همراه خود را وارد کنید.',
            'mobileNum.regex' => 'شماره تلفن همراه وارد شده معتبر نیست.',
            'mobileNum.digits' => 'شماره تلفن همراه باید 11 رقم باشد.',
            'userName.required' => 'لطفا نام کاریری را وارد نمایید.',
            'userName.max' => 'نام کاربری نمی تواند بیش از 60 کاراکتر باشد.',
            'userName.string'=>'در نام کاربری فقط اجازه دارید تا از حروف استفاده کنید',
            'email.required' => 'لطفا ایمیل خود را وارد کنید.',
            'email.unique' => 'این ایمیل قبلا استفاده شده است.',
            'email.email' => 'لطفا یک ایمیل معتبر وارد کنید.',
            'password.required' => 'لطفا رمز عبور خود را وارد نمایید.',
            'password.max' => 'رمزعبور نمی تواند بیش از 60 کاراکتر باشد.',
            'password.min' => 'رمزعبور نمی تواند کمتر از 8 کاراکتر باشد.',
            'password.confirmed' => 'رمز عبور و تکرار آن با هم یکی نیستند',
            'password_confirmation.max' => 'تکرار رمزعبور نمی تواند بیش از 60 کاراکتر باشد.',
            'password_confirmation.min' => 'تکرار رمزعبور نمی تواند کمتر از 8 کاراکتر باشد.',
        ];
    }
}
