<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class loginRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'mobile'  => ['required','digits:11','regex:/^(0)?(9[0-9]{9})$/'],
            'password'=>'required|max:60'
        ];
    }

    public function messages() {
        return [
            'mobile.required'               => 'لطفا شماره همراه را وارد کنید',
            'mobile.digits'                 => 'در فیلد شماره همراه فقط از اعداد استفاده کنید',
            'mobile.regex'          =>  'قالب شماره همراه صحیح نمی باشد',
            'password.required' => 'لطفا رمز عبور خود را وارد نمایید.',
            'password.max' => 'رمزعبور نمی تواند بیش از ۱۰۰ کاراکتر باشد.',
        ];
    }
}
